#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_NVRAM_SPACE 0x10000
#define PROFILE_HEADER		"HDR1"
#ifdef RTCONFIG_DSL
#define PROFILE_HEADER_NEW      "N55U"
#else
#define PROFILE_HEADER_NEW      "HDR2"
#endif



int nvram_restore_new(char *file, char *buf)
{
	FILE *fp;
	char header[8], *p, *v;
	unsigned long count, filelen, *filelenptr, i;
	unsigned char rand, *randptr;

	if ((fp = fopen(file, "r+")) == NULL) return -1;

	count = fread(header, 1, 8, fp);
	if (count>=8 && strncmp(header, PROFILE_HEADER, 4) == 0)
	{
		filelenptr = (unsigned long *)(header + 4);
		fread(buf, 1, *filelenptr, fp);
	}
	else if (count>=8)
	{
		filelenptr = (unsigned long *)(header + 4);
		filelen = *filelenptr & 0xffffff;
		randptr = (unsigned char *)(header + 7);
		rand = *randptr;
		count = fread(buf, 1, filelen, fp);
		for (i = 0; i < count; i++)
		{
			if ((unsigned char) buf[i] > ( 0xfd - 0x1))
				buf[i] = 0x0;
			else
				buf[i] = 0xff + rand - buf[i];
		}
	}
	else
	{
		fclose(fp);
		return 0;
	}
	fclose(fp);

	return 0;
}

int
main(int argc, char **argv)
{
	char *buf;
	int size;

	argv++;	
	buf = malloc (MAX_NVRAM_SPACE);
        memset(buf, 0, MAX_NVRAM_SPACE);
	if (buf == NULL)	{
		perror ("Out of memory!\n");
		return -1;
	}
        nvram_restore_new(*argv, buf);
        fwrite(buf, MAX_NVRAM_SPACE, 1, stdout);
	return 0;
}	

